libname q 'c:\SAScodeforBook\SASDataSets';

/* This code is designed to produce runs that may be comparable to those of SPSS*/
/* These runs do not use the Weight statement but do use the K-R corrections.*/
/* SPSS seems to have the K-R corrections when the Repeated statement is used*/ 

data first; set q.harfordschools;
if Scnum = 11 then delete;
if testyear = 2002 then delete;
if testyear = 2001 then delete;
period = testyear;

run;

data second; set first;
                 /*These are the design variables*/

*cnvsmach =  conect = 1, matched no conect = 0 , not matched no conect = missing dot;

group3 = . ;
if cnvsmach = 1 then group3= 1;
if cnvsmach = 0 then group3= 3;
if cnvsmach = . then group3= 2;

Trt = group3;
* Note:  the above code refers all comparisons to the matched group!;

group2 = .;
if cnvsmach = 1 then group2= 1;
Else group2 = 0;
* Note:  the above code refers all comparisons to the non co-nect groups;

                /*This code creates the year indicator variables */

year97 = . ;
if testyear = 1997 then year97 = 1;
else year97=0;

year98 = . ;
if testyear = 1998 then year98 = 1;
else year98=0;

year99 = . ;
if testyear = 1999 then year99 = 1;
else year99 = 0;

year20 = .;
if testyear = 2000 then year20 = 1;
else year20 = 0;

year21 = .;
if testyear = 2001 then year21 = 1;
else year21 = 0;

year22 = .;
if testyear = 2002 then year22 = 1;
else year22 = 0;


	/*This code groups all non conect together and creates indicator variable*/

cnvsall = . ;
if cnvsmach = . or cnvsmach = 0 then cnvsall = 0;
if cnvsmach = 1 then cnvsall = 1;

* This code breaks up the groups for detailed assessment;
conect=. ;
if group3 = 1 then conect=1;
else conect = 0;

nomatch =. ;
if group3 = 2 then nomatch = 1;
else nomatch = 0;

match =.;
if group3 = 3 then match = 1;
else match = 0;

conect98 = conect*year98;
conect99 = conect*year99;
conect20 = conect*year20;
conect21 = conect*year21;
conect22 = conect*year22;

nomat98 = nomatch*year98;
nomat99 = nomatch*year99;
nomat20 = nomatch*year20;
nomat21 = nomatch*year21;
nomat22 = nomatch*year22;

ryear20 = .;
if year20 = 1 then ryear20 = 0; *post time period;
if year20 = 0 then ryear20 = 1; *base period;

post = ryear20;

             /*These variables are properties of the school*/

*This code creates dummy variables for lowest grade of school, KG is one preKG is zero;

If substr (Low_Grade,1,12)=  'Kindergarten' then lowstgrd = 1;
If substr (Low_Grade,1,15)=  'Prekindergarten' then lowstgrd = 0;

*This code creates dummy variable for location, urban fringe is one rural is zero;
locate = .;

If substr (locale,1,26) = 'Urban Fringe of Large City' then locate =1;
else locate = 0;

*This code creates dummy variable for targeted title1 school, one is yes it is,zero is no;
*No Conect schools are Title1 schools;

TargetT1 = . ;
if substr (title1sc,1,2) = 'No' then TargetT1 = 0;
if substr (title1sc,1,3) = 'Yes' then TargetT1 = 1;


*This code creates targeted poverty under SAFE;
Safe = . ;
if scnum = 2 or scnum = 4 or scnum = 6 or scnum = 7 or scnum = 8 or scnum = 20
or scnum = 29 then safe = 1; Else safe = 0;

lowecon = . ;
if safe = 1 and targett1 = 1 then lowecon = 2;
else if safe = 0 and targett1 = 0 then lowecon = 0;
else lowecon = 1;



     /*These Codes refer to the composition of the school*/

*This creates a gender variable, female to male ratio;
Femvmal = female/male;
femprob = female/studentt;

*These codes create proportions for ethnicity;
Nativep = Native_A/studentt;
Asianp  = Asian/studentt;
Blackp  = Black/studentt;
Hispanp = Hispanic/studentt;
Whitep  = White/studentt;


                /*this code creates a simple weight by implementation variable Not used here*/

impscore = 1 ;
if scnum= 6 then do;
        impscore = 1.52;
        end;
if scnum = 7 then do;
        impscore = 1.56;
                end;
if scnum = 17 then do;
        impscore = 1.8;
        end;
if scnum = 25 then do;
        impscore = 1.79;
        end;
if scnum = 31 then do;
        impscore = 1.86;
        end;
run;


data third; set second;
if year97=1 or year98=1 or year99=1 or year20=1;
                                
consolidated = (msapperform + AveComp)/2;
 
        /* This code standardizes the variables by their means*/
Title 'Variables standardized by their means';
	proc standard data = third out= standard mean=0; 
	*weight impscore;
	var lowstgrd locate targett1 stratio femprob blackp forredlp safe year98 year99;

Title 'Means of standardized and not standardized variables';
	proc means data= standard;
	var lowstgrd locate targett1 stratio femprob blackp forredlp safe year98 year99
	year20 post msapperform avecomp consolidated gr3comp gr3read gr3math gr5comp gr5read gr5math; 
	*weight impscore; 
run;  

	                                     
data fourth; set standard;

/* These are the elements of the KR production runs most are with compound symmetry*/

/* Very Important Interpretive Note! 
 Post = ryear20 = zero it indicates year 2000 = post, when it is one it indicates 1997 = pre*/


			/*  Overall performance measures */


Title 'Ave Comp CS No KR No Weight Using Repeated Statement + Period  Figure 8.1';
	proc mixed data=standard covtest ratio ic;
	class  trt period school post ;
	model msapperform = trt post trt*post  year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/ s  cl DDFM = KR;
	repeated Period /type = cs sub= school(trt) r rcorr ;
	*weight impscore;
	lsmeans trt*post /cl;
run;


Title 'Ave Comp CS No KR No Weight Using Repeated Statement + Period  Figure 8.3';
	proc mixed data=standard covtest ratio ic;
	class  trt period school post ;
	model Avecomp = trt post trt*post  year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/ s  cl DDFM = KR;
	repeated Period /type = cs sub= school(trt) r rcorr ;
	*weight impscore;
	lsmeans trt*post /cl;
run;

		/* You may want to compare these data with the discussion in the text*/
Title 'Simple Average of SPI and CI CS No KR Using Repeated Statement + Period  ';
	proc mixed data=standard covtest ratio ic;
	class  trt period school post ;
	model consolidated = trt post trt*post year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/ s  cl DDFM = KR;
	repeated Period /type = cs sub= school(trt) r rcorr ;
	*weight impscore;
	lsmeans trt*post /cl;
run;

				/*  Grade 3 Tests begin here */

Title 'Gr3Comp CS No KR Using Repeated Statement + Period Hyp  Figure 8.4';
	proc mixed data=standard covtest ratio ic;
	class  trt period school post;
	model Gr3comp = trt post trt*post year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/ s  cl DDFM = KR;
	repeated Period /type = cs sub= school(trt) r rcorr ;
	*weight impscore;
	lsmeans trt*post /cl;
run;

Title 'Gr3 Reading VC No KR Using Repeated Statement + Period VC Figure 8.5';
	proc mixed data=standard covtest ratio ic ;
	class  trt period school post ;
	model gr3read = trt post trt*post year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/ s  cl DDFM = KR;
	repeated Period /type = VC sub= school(trt) r rcorr ;
	*weight impscore;
	lsmeans trt*post;
run;

Title 'Gr3 Math CS no KR  Using Repeated Statement + Period Hyp Figure 8.6 ';
	proc mixed data=standard covtest ratio ic ;
	class trt period school post;
	model gr3math = trt post trt*post year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/ s  cl DDFM = KR;
	repeated Period /type = cs sub= school(trt) r rcorr ;
	*weight impscore;
	lsmeans trt*post;
run;

	/*Grade 5 begins here.  For ease of interpretation ryear20 is used rather than post*/

Title 'Gr 5 Comp CS No KR Using Repeated Statement + Period Hyp  Figure 8.7';
	proc mixed data=standard covtest ratio ic ;
	class  trt period school ryear20 ;
	model gr5comp = trt ryear20 trt*ryear20  year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/ s  cl DDFM = KR;
	repeated Period /type = cs sub= school(trt) r rcorr ;
	*weight impscore;
	lsmeans trt*ryear20 ;
run;

Title 'Gr 5 Read CSH no KR Using Repeated Statement + Period Hyp Figure 8.8 ';
proc mixed data=standard covtest ratio ic ;
	class  trt period school ryear20 ;
	model gr5read = trt ryear20 trt*ryear20  year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/ s  cl DDFM = KR;
	repeated Period /type = csh sub= school(trt) r rcorr ;
	*weight impscore;
	lsmeans trt*ryear20 ;
run;


Title 'Gr 5 Math CS no KR Using Repeated Statement + Period Hyp Figure 8.9 ';
	proc mixed data=standard covtest ratio ic ;
	class  trt period school ryear20 ;
	model gr5math = trt ryear20 trt*ryear20  year98 year99 lowstgrd Locate targett1 safe
	Stratio femprob Blackp forredlp
	/ s  cl DDFM = KR;
	repeated Period /type = cs sub= school(trt) r rcorr ;
	*weight impscore;
	lsmeans trt*ryear20 ;
run;

				/*End of No Weighting Production Code*/

				/*The syntax in this file is copyright by Robert B. Smith,  2011 */
